<?php
namespace SabaiApps\Directories\Component\Dashboard\DisplayButton;

use SabaiApps\Directories\Component\Display;
use SabaiApps\Directories\Application;
use SabaiApps\Directories\Component\Entity\Model\Bundle;
use SabaiApps\Directories\Component\Entity\Type\IEntity;

abstract class AbstractPostDisplayButton extends Display\Button\AbstractButton
{    
    protected $_route, $_modalDanger, $_allowGuest;
    
    public function __construct(Application $application, $name, $route, $modalDanger = false, $allowGuest = false)
    {
        parent::__construct($application, $name);
        $this->_route = $route;
        $this->_modalDanger = (bool)$modalDanger;
        $this->_allowGuest = (bool)$allowGuest;
    }
    
    public function displayButtonLink(Bundle $bundle, IEntity $entity, array $settings, $displayName)
    {
        if (!$this->_application->Entity_IsRoutable($bundle, $this->_route, $entity)) return;
        
        if ($this->_application->getUser()->isAnonymous()) {
            if (!$this->_allowGuest) return;
            
            return; // @todo create pages for guest users to edit/delete posts
        }

        if ($this->_route !== 'edit') {
            $this->_application->getPlatform()->addJsFile('form.min.js', 'drts-form', array('drts')); // for modal form
        }

        $label = $this->_getLabel($bundle, $entity, $settings);
        $attr = [
            'class' => $settings['_class'],
            'style' => $settings['_style'],
            'data-modal-title' => $label . ' - ' . $this->_application->Entity_Title($entity),
            'data-modal-danger' => empty($this->_modalDanger) ? 0 : 1,
        ];
        $link = $this->_application->LinkTo(
            $label,
            $this->_getUrl($bundle, $entity, $settings, $displayName),
            $this->_getLinkOptions($bundle, $entity, $settings, $displayName),
            $attr
        );
        return $this->_application->Filter('dashboard_post_display_button_link', $link, [$entity, $displayName]);
    }

    protected function _getLinkOptions(Bundle $bundle, IEntity $entity, array $settings, $displayName)
    {
        $options = [];
        if (!empty($settings['_icon'])) {
            $options['icon'] = 'fa-fw ' . $settings['_icon'];
        }
        if ($this->_route !== 'edit') {
            $options['container'] = 'modal';
        }
        return $options;
    }
    
    protected function _getUrl(Bundle $bundle, IEntity $entity, array $settings, $displayName)
    {
        $params = [];
        if ($displayName === 'dashboard_row') {
            $params['from_dashboard'] = 1;
        }

        $path = $this->_route === 'edit' ? '/' : '/' . $this->_route;

        return $this->_application->getComponent('Dashboard')->getPostsPanelUrl($entity, '/posts/' . $entity->getId() . $path, $params, true);
    }
    
    protected function _getLabel(Bundle $bundle, IEntity $entity, array $settings)
    {
        return $settings['_label'];
    }
}